// $Id: CPen.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPen.hpp"
using Exponent::GUI::Graphics::CPen;


//	===========================================================================
CPen::CPen()
	: m_width(1)
#ifdef WIN32
	, m_hOld(NULL)
	, m_hdc(NULL)
	, m_pen(NULL)
#else
	, m_drawContext(NULL)
#endif
{
#ifdef WIN32
	NULL_POINTER(m_hOld);
	NULL_POINTER(m_hdc);
	NULL_POINTER(m_pen);
#else
	NULL_POINTER(m_drawContext);
#endif
	m_width  = 1;
	m_colour = CAlphaColour::CALPHACOLOUR_BLACK;
}

//	===========================================================================
CPen::~CPen()
{
	this->deletePen();
}

#ifdef WIN32
//	===========================================================================
void CPen::initialise(long width, HDC drawContext, const CAlphaColour &colour)
{
	m_hdc = drawContext;
	this->setWidth(width);
	this->setColour(colour);
}

//	===========================================================================
void CPen::setPenToNullPen()
{
	DeleteObject(m_pen);
	m_pen  = CreatePen(PS_NULL, m_width, NULL);
	m_hOld = SelectObject(m_hdc, m_pen);
}
#else
//	===========================================================================
void CPen::initialise(CGContextRef drawContext, long size, const CAlphaColour &colour)
{
	m_drawContext = drawContext;
	this->setWidth(size);
	this->setColour(colour);
}
#endif

//	===========================================================================
void CPen::uninitialise()
{
	this->deletePen();
}

//	===========================================================================
void CPen::setPen(long width, const CAlphaColour &colour)
{
	this->setWidth(width);
	this->setColour(colour);
}

//	===========================================================================
void CPen::setWidth(const long width)
{
	m_width = width;
#ifdef WIN32
	this->createPen();
#else
	CGContextSetLineWidth(m_drawContext, m_width);
#endif
}

//	===========================================================================
void CPen::setColour(const CAlphaColour &colour)
{
	m_colour = colour;
#ifdef WIN32
	this->createPen();
#else
	CGContextSetRGBStrokeColor(m_drawContext, colour.getRed() / 255.f, colour.getGreen() / 255.f, colour.getBlue() / 255.f, 1.f);	// Alpha can be done here
#endif
}

//	===========================================================================
void CPen::createPen()
{
#ifdef WIN32
	DeleteObject(m_pen);
	m_pen  = CreatePen(PS_SOLID, m_width, m_colour.getAsColourRef());
	m_hOld = SelectObject(m_hdc, m_pen);
#endif
}

//	===========================================================================
void CPen::deletePen()
{
#ifdef WIN32
	if (m_hdc)
	{
		SelectObject(m_hdc, m_hOld);
		m_hdc  = NULL;
		m_hOld = NULL;
	}
	DeleteObject(m_pen);
#else
	PenNormal();
#endif
}